import { AmplifyListUsersResult } from "./actions";
import { validateSchema } from "@/lib/zod/validator";
import { AppUser, listUsersResultSchema } from "../zod/amplify.schema";
import { AppUserGroup } from "@/zod/amplify.schema";

type INTERNAL__TransformedUser = ReturnType<typeof INTERNAL__transformUser>

export function transformListUsersResult(result: AmplifyListUsersResult) {
  if (!result.data) {
    return;
  }

  if (typeof result.data !== 'string') {
    return;
  }

  const data = JSON.parse(result.data)
  const validated = validateSchema({
    dto: data,
    schema: listUsersResultSchema,
    schemaName: "listUsersResultSchema - "
  });

  const pending: INTERNAL__TransformedUser[] = []
  const verified: INTERNAL__TransformedUser[] = []
  for (const user of validated.admin.Users) {
    const userStatus = user.UserStatus;
    const transformedUser = INTERNAL__transformUser(user, 'ADMIN')
    if (userStatus !== 'CONFIRMED') {
      pending.push(transformedUser)
    } else {
      verified.push(transformedUser)
    }
  }

  for (const user of validated.viewer.Users) {
    const userStatus = user.UserStatus;
    const transformedUser = INTERNAL__transformUser(user, 'VIEWER')
    if (userStatus !== 'CONFIRMED') {
      pending.push(transformedUser)
    } else {
      verified.push(transformedUser)
    }
  }

  return {
    pending,
    verified,
  };
}

function INTERNAL__transformUser(user: AppUser, group: AppUserGroup) {
  const email = user.Attributes.find((a) => a.Name === 'email')

  return {
    displayName: email?.Value ?? user.Username,
    group: group
  }
}

